// Title      : Post.java
// Author     : James Baird
// Created    : Friday, 10th August 2001
// Description: Post Class

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Post
{
  public Post(String newsgroup, int article, Vector header, Vector body)
  {
    this.newsgroup = newsgroup;
    this.article = article;
    this.header = header;
    this.body = body;
  }

  public String getHeaderRow(String tag)
  {
    String result = null;

    for (int i = 0; i < header.size(); i++)
    {
      String row = (String)header.elementAt(i);

      if (row.startsWith(tag + ":"))
      {
        result = row.substring(tag.length() + 2);

        break;
      }
    }

    return result;
  }

  public Calendar getDate()
  {
    Calendar result = null;

    String date = getHeaderRow("Date");

    if (date != null)
    {
      StringTokenizer tokeniser = new StringTokenizer(date);

      String dd = null;
      String mm = null;
      String yyyy = null;
      String time = null;
      String zone = null;

      while (tokeniser.hasMoreTokens())
      {
        String token = tokeniser.nextToken();

        if (dd == null)
        {
          if (Character.isDigit(token.charAt(0)))
            dd = token;
        }
        else if (mm == null)
          mm = token.toLowerCase();
        else if (yyyy == null)
          yyyy = token;
        else if (time == null)
          time = token;
        else if (zone == null)
        {
          zone = token;

          break;
        }
      }

      if (dd != null && mm != null && yyyy != null)
      {
        if (time == null)
          time = "00:00:00";

        if (zone == null)
          zone = "GMT";

        int offset = 0;

        if (zone.length() == 3)
        {
          TimeZone other = TimeZone.getTimeZone(zone);

          offset = -(other.getRawOffset() / (1000 * 3600));          
        }
        else
        {
          offset = Integer.parseInt(zone.substring(1)) / 100;

          if (!zone.startsWith("-"))
            offset = -offset;
        }

        int month = -1;

        if (mm.equals("jan"))
          month = Calendar.JANUARY;
        else if (mm.equals("feb"))
          month = Calendar.FEBRUARY;
        else if (mm.equals("mar"))
          month = Calendar.MARCH;
        else if (mm.equals("apr"))
          month = Calendar.APRIL;
        else if (mm.equals("may"))
          month = Calendar.MAY;
        else if (mm.equals("jun"))
          month = Calendar.JUNE;
        else if (mm.equals("jul"))
          month = Calendar.JULY;
        else if (mm.equals("aug"))
          month = Calendar.AUGUST;
        else if (mm.equals("sep"))
          month = Calendar.SEPTEMBER;
        else if (mm.equals("oct"))
          month = Calendar.OCTOBER;
        else if (mm.equals("nov"))
          month = Calendar.NOVEMBER;
        else if (mm.equals("dec"))
          month = Calendar.DECEMBER;

        result = new GregorianCalendar();

        result.clear();

        result.set(Integer.parseInt(yyyy), month, Integer.parseInt(dd));

        time += ":00";

        if (time.substring(1,2).equals(":"))
          time = "0" + time;

        String hours = time.substring(0, 2);

        String mins = time.substring(3, 5);

        String secs = time.substring(6, 8);

        result = new GregorianCalendar();

        result.clear();

        result.set(Integer.parseInt(yyyy), month, Integer.parseInt(dd), Integer.parseInt(hours), Integer.parseInt(mins), Integer.parseInt(secs));

        result.add(Calendar.HOUR_OF_DAY, offset);
      }
    }

    return result;
  }

  public Element toElement(Document document)
  {
    Element result = document.createElement("post");
    result.setAttribute("article", Integer.toString(article));

    Calendar postDate = getDate();

    result.setAttribute("day", Integer.toString(postDate.get(Calendar.DAY_OF_MONTH)));
    result.setAttribute("month", Integer.toString(postDate.get(Calendar.MONTH)));
    result.setAttribute("year", Integer.toString(postDate.get(Calendar.YEAR)));
    result.setAttribute("hours", Integer.toString(postDate.get(Calendar.HOUR_OF_DAY)));
    result.setAttribute("mins", Integer.toString(postDate.get(Calendar.MINUTE)));
    result.setAttribute("secs", Integer.toString(postDate.get(Calendar.SECOND)));

    result.setAttribute("subject", getSubject());

    Element headerElement = toElement(document, "header", header);
    Element bodyElement = toElement(document, "body", body);
    
    NodeList nodeList = bodyElement.getChildNodes();
    
    result.setAttribute("length", Integer.toString(nodeList.getLength()));

    result.appendChild(headerElement);
    result.appendChild(bodyElement);

    return result;
  }

  protected Element toElement(Document document, String tag, Vector vector)
  {
    Element element = document.createElement(tag);

    for (int i = 0; i < vector.size(); i++)
    {
      Element paragraph = document.createElement("paragraph");

      Text text = document.createTextNode((String)vector.elementAt(i));

      paragraph.appendChild(text);

      element.appendChild(paragraph);
    }

    return element;
  }

  public String getSubject()
  {
    return getHeaderRow("Subject");
  }

  public String getGroup()
  {
    return newsgroup;
  }

  public int getArticle()
  {
    return article;
  }

  public Vector getHeader()
  {
    return header;
  }

  public Vector getBody()
  {
    return body;
  }

  String newsgroup;
  int article;
  Vector header;
  Vector body;
}
